% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pfm_comparison.R
\name{motifKmerSimilarity}
\alias{motifKmerSimilarity}
\title{Calculate similarities between motifs and k-mers.}
\usage{
motifKmerSimilarity(
  x,
  kmerLen = 5,
  kmers = NULL,
  includeRevComp = FALSE,
  BPPARAM = SerialParam(),
  verbose = FALSE
)
}
\arguments{
\item{x}{Either a \code{\link[TFBSTools]{PFMatrixList}}, or a character
scalar with a file containing motifs in HOMER format (used directly
\code{method = "HOMER"}, loaded into a
\code{\link[TFBSTools]{PFMatrixList}} by \code{\link{homerToPFMatrixList}}
for \code{method = "R"}).}

\item{kmerLen}{A \code{numeric} scalar giving the k-mer length.}

\item{kmers}{Either a character vector of k-mers for which to calculate
the similarity to each motif, or \code{NULL}, in which case all k-mers
of length \code{kmerLen} are used.}

\item{includeRevComp}{A \code{logical} scalar. If set to \code{TRUE}, each
k-mer as well as its reverse complement is compared to each motif, and the
larger of the two similarities is returned.}

\item{BPPARAM}{An optional \code{\link[BiocParallel]{BiocParallelParam}}
instance determining the parallel back-end to be used during evaluation.}

\item{verbose}{A logical scalar. If \code{TRUE}, report on progress.}
}
\value{
A matrix of probabilties for each motif - k-mer pair.
}
\description{
For each motif, calculate it's similarity to all k-mers of
  length \code{kmerLen}, defined as the maximal probability of observing the
  k-mer given the base frequencies of the motif (the maximum is taken over
  for all possible ungapped alignments between motif and k-mer). If necessary
  matrices are padded on the sides with background base frequencies (assuming
  all bases to have a frequency of 0.25).
}
\examples{
m <- rbind(A = c(12,  0,  0),
           C = c( 3,  2,  0),
           G = c( 0, 14,  0),
           T = c( 0,  0, 15))
pfms <- TFBSTools::PFMatrixList(
    TFBSTools::PFMatrix(name = "m1", profileMatrix = m),
    TFBSTools::PFMatrix(name = "m2", profileMatrix = m[, 3:1])
)
motifKmerSimilarity(pfms, kmerLen = 3)[, c("AGT", "TGA")]

}
\seealso{
\code{\link[BiocParallel]{bplapply}} used for parallelization.
}
