% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motif_enrichment_kmers.R
\name{.calcKmerEnrichment}
\alias{.calcKmerEnrichment}
\title{Calculate k-mer enrichment}
\usage{
.calcKmerEnrichment(k, df, test = c("fisher", "binomial"), verbose = FALSE)
}
\arguments{
\item{k}{Numeric scalar giving the length of k-mers to analyze.}

\item{df}{A \code{DataFrame} with sequence information as returned by
\code{.iterativeNormForKmers()}.}

\item{test}{Type of motif enrichment test to perform.}

\item{verbose}{A logical scalar. If \code{TRUE}, report on progress.}
}
\value{
A \code{data.frame} containing the motifs as rows and the columns:
  \describe{
    \item{motifName}{: the motif name}
    \item{logP}{: the log p-value for enrichment (natural logarithm).
       If \code{test="binomial"} (default), this log p-value is identical to
       the one returned by Homer.}
    \item{sumForegroundWgtWithHits}{: the weighted number of k-mer hits in
       foreground sequences.}
    \item{sumBackgroundWgtWithHits}{: the weighted number of k-mer hits in
       background sequences.}
    \item{totalWgtForeground}{: the total sum of weights of foreground
       sequences.}
    \item{totalWgtBackground}{: the total sum of weights of background
       sequences.}
  }
}
\description{
Given sequences, foreground/background labels and
  weights, calculate the enrichment of each k-mer
  in foreground compared to background. This function is called by
  \code{calcBinnedKmerEnr()} for each bin if \code{background != "model"}.

  The default type of test is \code{"fisher"}.
  Alternatively, a binomial test can be used by \code{test = "binomial"}.
  Using Fisher's exact test has the advantage that special cases such as
  zero background counts are handled without ad-hoc adjustments to the
  k-mer frequencies.

  For \code{test = "fisher"}, \code{fisher.test} is used with
  \code{alternative = "greater"}, making it a one-sided test for enrichment,
  as is the case with the binomial test.
}
\details{
The function works in ZOOPS mode, which means only one
  or zero occurrences of a k-mer are considered per sequence. This is helpful
  to reduce the impact of simple sequence repeats occurring in few sequences.
}
\keyword{internal}
