% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBinDiagnostics.R
\name{plotBinDiagnostics}
\alias{plotBinDiagnostics}
\title{Plot diagnostics of binned sequences}
\usage{
plotBinDiagnostics(
  seqs,
  bins,
  aspect = c("length", "GCfrac", "dinucfreq"),
  draw_quantiles = c(0.25, 0.5, 0.75),
  ...
)
}
\arguments{
\item{seqs}{\code{\link[Biostrings]{DNAStringSet}} object with sequences.}

\item{bins}{Factor of the same length and order as \code{seqs}, indicating
the bin for each sequence. Typically the return value of \code{bin}.}

\item{aspect}{The diagnostic to plot. Should be one of \code{"length"},
\code{"GCfrac"} and \code{"dinucfreq"}, to plot the distribution of
sequence lengths, the distribution of GC fractions and the average
relative dinucleotide frequencies across the bins.}

\item{draw_quantiles}{For aspect=\code{"length"} or \code{"GCfrac"},
draw vertical lines at the given quantiles of the density estimate.
If \code{NULL}, no quantile lines will be drawn.}

\item{...}{Additional argument passed to \code{getColsByBin}.}
}
\value{
For aspect=\code{"length"} or \code{"GCfrac"}, returns a
  \code{\link[ggplot2]{ggplot}} object. For aspect=\code{"dinucfreq"},
  returns (invisibly) a \code{\link[ComplexHeatmap]{Heatmap-class}} object.
}
\description{
Plot various diagnostics of binned sequences. Three plot types are
available:
\describe{
\item{\code{length}}{ plots the distribution of sequence lengths within
  each bin.}
\item{\code{GCfrac}}{ plots the distribution of GC fractions within each
  bin.}
\item{\code{dinucfreq}}{ plots a heatmap of the relative frequency of each
  dinucleotide, averaged across the sequences within each bin. The values
  are centered for each dinucleotide to better highlight differences
  between the bins. The average relative frequency of each dinucleotide
  (across the bins) is indicated as well.}
}
}
\examples{
seqs <- Biostrings::DNAStringSet(
  vapply(1:250, function(i) paste(sample(x = c("A", "C", "G", "T"),
                                         size = round(stats::rnorm(1, 20, 5)),
                                         replace = TRUE), collapse = ""), "")
)
bins <- factor(rep(c("a", "b", "c", "d", "e"), each = 50))
plotBinDiagnostics(seqs, bins, aspect = "length")
plotBinDiagnostics(seqs, bins, aspect = "GCfrac", draw_quantiles = NULL)
plotBinDiagnostics(seqs, bins, aspect = "dinucfreq")

}
