% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_enrichment.R
\name{.defineBackground}
\alias{.defineBackground}
\title{Define background sequence set for a single motif enrichment
  calculation}
\usage{
.defineBackground(
  sqs,
  bns,
  bg,
  currbn,
  gnm,
  gnm.regions,
  gnm.oversample,
  maxFracN = 0.7,
  GCbreaks = c(0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5, 0.6, 0.7, 0.8)
)
}
\arguments{
\item{sqs, bns, bg}{The \code{seqs}, \code{bins} and \code{background}
arguments from \code{calcBinnedMotifEnrR}.}

\item{currbn}{An \code{integer} scalar with the current bin defining the
foreground sequences.}

\item{gnm, gnm.regions, gnm.oversample}{The \code{genome},
\code{genome.regions} and \code{genome.oversample} arguments from
\code{calcBinnedMotifEnrR}.}

\item{maxFracN}{The \code{maxFracN} argument from \code{calcBinnedMotifEnrR}.}

\item{GCbreaks}{The breaks between GC bins. The default value is based on
the hard-coded bins used in Homer.}
}
\value{
A \code{DataFrame} with sequences represented by rows and columns
  \code{seqs}, \code{isForeground}, \code{GCfrac}, \code{GCbin}, \code{GCwgt}
  and \code{seqWgt}. Only the first three are already filled in.
}
\description{
Define the background set for the motif enrichment calculation
  in a single bin, depending on the background mode and given foreground
  sequences.
}
\keyword{internal}
