% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSamplePCA.R
\name{plotSamplePCA}
\alias{plotSamplePCA}
\title{PCA plot of PC1 and PC2}
\usage{
plotSamplePCA(
  data,
  group,
  vst = FALSE,
  labels = TRUE,
  boxed = TRUE,
  legend.title = "Conditions",
  size.ratio = 2,
  colours = NULL,
  point.shape = TRUE,
  ggplot.theme = NULL,
  label.box.padding = 1,
  title = "PCA plot",
  legend.position = "top",
  legend.direction = "horizontal"
)
}
\arguments{
\item{data}{data.frame; originally generated by \code{\link[=RNAimport]{RNAimport()}}}

\item{group}{character; contains experimental conditions for each
replicate.

\emph{IMPORTANT}: Ensure this is in the same order as the replicates are
found in the data frame supplied to the \code{data} argument (from left to right).}

\item{vst}{logical; variance stabilizing transformation. By default, the
function uses a regularized log transformation on the data set, however, this
will not suit all experimental designs.}

\item{labels}{logical; include sample name labels on PCA. Default
\code{labels=TRUE}}

\item{boxed}{logical; add a box around each sample name label. Default
\code{boxed=TRUE}}

\item{legend.title}{character; title for legend key. Default
\code{legend.title = "Conditions"}}

\item{size.ratio}{numeric; set plot ratio, broadens axis dimensions by ratio.
Default \code{size.ratio=2}, double the plot dimension.}

\item{colours}{character; vector of HEX colour codes. Must match the number of
conditions.}

\item{point.shape}{logical; set whether the point shapes should be different
for each condition.}

\item{ggplot.theme}{character; state the \code{ggplot2} theme (without ()
brackets). For example, \code{ggplot.theme=ggplot2::theme_classic}.}

\item{label.box.padding}{numeric; Amount of padding around bounding box,
as a unit or number. Defaults to 1.}

\item{title}{character; title for plot.}

\item{legend.position}{character; the position of legends
("none", "left", "right", "bottom", "top", or two-element numeric vector)}

\item{legend.direction}{character; layout of items in legends
("horizontal" or "vertical")}
}
\value{
A PCA plot to show sample distance.
}
\description{
Draws a principal component analysis (PCA) plot of PC1 and PC2.
The function undertakes rlog transformation of the data in an unbiased manner
(\code{blind=TRUE}).
}
\details{
This function uses the \code{DESeq2} package to organise and plot the
data. It organises the data into a DESeqDataSet which undergoes
log-transformation where the results are used to undertake the PCA analysis.
The results are plotted against the principal  components 1 and 2.

In special conditions, regularized log transformation will not suit
the experimental design. For example, an experimental design without
replicates. In this instance, it is preferable to change the default setting
and switch to a variance stabilizing transformation method
(\code{`vst=TRUE`}).
}
\examples{
data("sRNA_data")

groups <- c("Heterograft", "Heterograft", "Heterograft",
            "Selfgraft", "Selfgraft", "Selfgraft")
            
            
p <-  plotSamplePCA(data = sRNA_data, group = groups)

plot(p)


}
