% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DE_timepoints.R
\name{perWeek_barplot}
\alias{perWeek_barplot}
\title{Creates barplot of results of per-timepoint comparison}
\usage{
perWeek_barplot(
  de_results,
  type = c("qval", "pval"),
  labels = NULL,
  threshold = 0.05,
  xlab = "Timepoint",
  ylab = "Number of DE genes",
  main = "",
  ...
)
}
\arguments{
\item{de_results}{results from \code{\link{DE_timepoints}}}

\item{type}{type of p-value to count ("qval" or "pval")}

\item{labels}{labels to give each bar}

\item{threshold}{cutoff for counting gene as DE}

\item{xlab}{x-axis label}

\item{ylab}{y-axis label}

\item{main}{title of plot}

\item{...}{arguments passed to \code{\link{barplot}}}
}
\value{
This is a plotting function, and returns (invisibly) the results of 
  \code{\link{barplot}}
}
\description{
Creates barplot of results of per-timepoint comparison
}
\details{
\code{create_timepoints_contrasts} creates the needed contrasts for
  comparing two groups for every timepoint in the format needed for
  \code{DE_timepoints} (i.e. \code{\link[limma]{makeContrasts}}, to which the
  contrasts are ultimately passed). The time points are determined by the
  meta data in the \code{moanin_object} provided by the user.
}
\examples{
data(exampleData)
moanin <- create_moanin_model(data=testData, meta=testMeta)
contrasts <- create_timepoints_contrasts(moanin, "C", "K")
deTimepoints <- DE_timepoints(moanin, 
    contrasts=contrasts, use_voom_weights=FALSE)
perWeek_barplot(deTimepoints)
}
