% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnems.r
\name{bootstrap}
\alias{bootstrap}
\title{Bootstrap.}
\usage{
bootstrap(x, size = 1000, p = 1, logtype = 2, complete = FALSE, ...)
}
\arguments{
\item{x}{mnem object}

\item{size}{size of the booststrap simulations}

\item{p}{percentage of samples (e.g. for 100 E-genes p=0.5 means
sampling 50)}

\item{logtype}{logarithm type of the data (e.g. 2 for log2 data or exp(1)
for natural)}

\item{complete}{if TRUE, complete data log likelihood is considered (for
very large data sets, e.g. 1000 cells and 1000 E-genes)}

\item{...}{additional parameters for the nem function}
}
\value{
returns bootstrap support for each edge in each component (phi); list
of adjacency matrices
}
\description{
Run bootstrap simulations on the components (phi)  of an object of
class mnem.
}
\examples{
sim <- simData(Sgenes = 3, Egenes = 2, Nems = 2, mw = c(0.4,0.6))
data <- (sim$data - 0.5)/0.5
data <- data + rnorm(length(data), 0, 1)
result <- mnem(data, k = 2, starts = 1)
boot <- bootstrap(result, size = 2)
}
\author{
Martin Pirkl
}
