% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/one2manySponge.R
\name{one2manySponge}
\alias{one2manySponge}
\title{Sparse Partial Correlations On mRNA/miRNA Expression
We make mirTarRnaSeq compatible to SPONGE package in order to estimate
sparse matrix correlation (using elstic net) for prediction potential miRNA-mRNA
interaction. Note this function/method is suggested for miRNA/mRNA interactions
in many samples with a notable variance of mRNA/miRNA expression. This model also
only reports negative sparse partial correlation predictions.}
\usage{
one2manySponge(mirna_exp, diff_exp, miranda_sponge_predict, non_null = TRUE)
}
\arguments{
\item{mirna_exp}{miRna expression data.frame with miRNA for rows and samples for columns}

\item{diff_exp}{mRNA expression data.frame with mRNA for rows and samples for columns}

\item{miranda_sponge_predict}{miRanda sponge compatible matrix produced by miranda_sponge_predict function}

\item{non_null}{The default for this parameter is TRUE, hence it returns only non-null estimated if
FALSE it would return all NULL and TRUE estimates.}
}
\value{
matrix adjacency matrix with column names miRNA and row names mRNA
}
\description{
Sparse Partial Correlations On mRNA/miRNA Expression
We make mirTarRnaSeq compatible to SPONGE package in order to estimate
sparse matrix correlation (using elstic net) for prediction potential miRNA-mRNA
interaction. Note this function/method is suggested for miRNA/mRNA interactions
in many samples with a notable variance of mRNA/miRNA expression. This model also
only reports negative sparse partial correlation predictions.
}
\keyword{Sponge,}
\keyword{ceRNA}
\keyword{correlation,}
\keyword{mirTarRnaSeq,}
\keyword{partial}
\keyword{sparse}
