% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generics.R
\name{net_cls}
\alias{net_cls}
\title{Network clustering of sparsed adjacacency matrix.}
\usage{
net_cls(x, method, ...)
}
\arguments{
\item{x}{An object of class `mina` with `adj` defined.}

\item{method}{The clustering method used.}

\item{...}{Additional parameters.}
}
\value{
The network clustering results.
}
\description{
Network clustering of sparsed adjacacency matrix.
}
\examples{
maize <- new("mina", tab = maize_asv2, des = maize_des2)
maize <- norm_tab(maize, method = "raref", depth = 1000)
maize <- fit_tabs(maize)
maize <- adj(maize, method = "spearman")
maize <- net_cls(maize, method = "mcl", cutoff = 0.4, neg = FALSE)
}
