% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adj.R
\name{adj,mina,ANY-method}
\alias{adj,mina,ANY-method}
\alias{adj,mina,character-method}
\title{Calculate the adjacency matrix of `norm` by correlation with `mina` class
object as input.}
\usage{
\S4method{adj}{mina,ANY}(x, method, sig = FALSE, threads = 80, nblocks = 400, ...)

\S4method{adj}{mina,character}(x, method, sig = FALSE, threads = 80, nblocks = 400, ...)
}
\arguments{
\item{x}{An object of the class mina with `norm` defined or a `norm` matrix.}

\item{method}{The correlation coeffient used for adjacacency matrix.}

\item{sig}{The asymtotic P-values, only applicable for Pearson and Spearman
methods, FALSE by default.}

\item{threads}{The number of threads used for parallel running, 80 by
default.}

\item{nblocks}{The number of row/column for splitting sub-matrix, 400 by
default.}

\item{...}{Additional parameters.}
}
\value{
x The same `mina` object with `adj` added.
}
\description{
Calculate the adjacency matrix of `norm` by correlation with `mina` class
object as input.
}
\examples{
maize <- new("mina", tab = maize_asv2, des = maize_des2)
maize <- norm_tab(maize, method = "raref")
maize <- fit_tabs(maize)
maize <- adj(maize, method = "spearman", sig = FALSE)
}
