% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.r
\name{arle}
\alias{arle}
\title{Array relative log expression}
\usage{
arle(x, log2 = TRUE, normalize = TRUE)
}
\arguments{
\item{x}{a three-dimensional \code{\link{array}} of matrices}

\item{log2}{should values be $log_2$ transformed}

\item{normalize}{should values be quantile normalized}
}
\value{
an \code{\link{array}} with the same dimensions as \code{x}
}
\description{
The relative log expression (RLE) quantifies the extent to which each sample
in a dataset differs from a "reference" sample, which represents each probe's
median value across all samples.
}
\examples{
# microarray visualization
if (require(affydata, quietly = TRUE)) {
  data("Dilution", package = "affydata")
  x <- arle(marray(Dilution, transpose = TRUE))
}

}
\seealso{
\code{\link[affyPLM]{RLE}}

Other array.transformations: \code{\link{arank}}
}

