% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsingFunctions.R
\name{readKirCalls}
\alias{readKirCalls}
\title{Read KIR calls}
\usage{
readKirCalls(file, na.strings = c("", "NA", "uninterpretable"))
}
\arguments{
\item{file}{Path to input file.}

\item{na.strings}{a character vector of strings which are to be
    interpreted as \code{\link{NA}} values.  Blank fields are also
    considered to be missing values in logical, integer, numeric and
    complex fields.  Note that the test happens \emph{after} 
    white space is stripped from the input, so \code{na.strings} 
    values may need their own white space stripped in advance.}
}
\value{
Data frame containing KIR gene's counts. First column hold samples 
  IDs, further columns hold KIR genes presence / absence indicators.
}
\description{
\code{readKirCalls} read KIR calls from file.
}
\details{
Input file has to be a tsv formatted table. First column should be named
"ID" and contain samples IDs, further columns should hold KIR genes presence
/ absence indicators. See
\code{system.file("extdata", "MiDAS_tut_KIR", package = "midasHLA")} for an
example.
}
\examples{
file <- system.file("extdata", "MiDAS_tut_KIR.txt", package = "midasHLA")
readKirCalls(file)

}
