% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{checkAlleleFormat}
\alias{checkAlleleFormat}
\title{Check HLA allele format}
\usage{
checkAlleleFormat(allele)
}
\arguments{
\item{allele}{Character vector with HLA allele numbers.}
}
\value{
Logical vector specifying if \code{allele} elements follows HLA
  alleles naming conventions.
}
\description{
\code{checkAlleleFormat} test if the input character follows HLA nomenclature
specifications.
}
\details{
Correct HLA number should consist of HLA gene name followed by "*" and sets
of digits separated with ":". Maximum number of sets of digits is 4 which
is termed 8-digit resolution. Optionally HLA numbers can be supplemented with
additional suffix indicating its expression status. See
\url{http://hla.alleles.org/nomenclature/naming.html} for more details.

HLA alleles with identical sequences across exons encoding the peptide
binding domains might be designated with G group allele numbers. Those
numbers have additional G or GG suffix. See
\url{http://hla.alleles.org/alleles/g_groups.html} for more details. They are
interpreted as valid HLA alleles designations.
}
\examples{
allele <- c("A*01:01", "A*01:02")
checkAlleleFormat(allele)

}
