% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{core}
\alias{core}
\alias{filter_prevalent}
\title{Core Microbiota}
\usage{
core(x, detection, prevalence, include.lowest = FALSE, ...)
}
\arguments{
\item{x}{\code{\link{phyloseq-class}} object}

\item{detection}{Detection threshold for absence/presence
(strictly greater by default).}

\item{prevalence}{Prevalence threshold (in [0, 1]). The
required prevalence is strictly greater by default. To include the
limit, set include.lowest to TRUE.}

\item{include.lowest}{Include the lower boundary of the detection and
prevalence cutoffs. FALSE by default.}

\item{...}{Arguments to pass.}
}
\value{
Filtered phyloseq object including only prevalent taxa
}
\description{
Filter the phyloseq object to include only prevalent taxa.
}
\examples{
data(dietswap)
# Detection threshold 0 (strictly greater by default);
# Prevalence threshold 50 percent (strictly greater by default)
pseq <- core(dietswap, 0, 50/100)
# Detection threshold 0 (strictly greater by default);
# Prevalence threshold exactly 100 percent; for this set
# include.lowest=TRUE, otherwise the required prevalence is 
# strictly greater than 100
pseq <- core(dietswap, 0, 100/100, include.lowest = TRUE)
}
\references{
Salonen A, Salojarvi J, Lahti L, de Vos WM. The adult intestinal
core microbiota is determined by analysis depth and health
status. Clinical Microbiology and Infection 18(S4):16-20, 2012
To cite the microbiome R package, see citation('microbiome')
}
\seealso{
core_members, rare_members
}
\author{
Contact: Leo Lahti \email{microbiome-admin@googlegroups.com}
}
\keyword{utilities}
