% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/getPERMANOVA.R
\name{getPERMANOVA}
\alias{getPERMANOVA}
\alias{addPERMANOVA}
\alias{getPERMANOVA,SingleCellExperiment-method}
\alias{getPERMANOVA,SummarizedExperiment-method}
\alias{getPERMANOVA,ANY-method}
\alias{addPERMANOVA,SummarizedExperiment-method}
\title{Calculate PERMANOVA (Permutational Multivariate Analysis of Variance)}
\usage{
getPERMANOVA(x, ...)

addPERMANOVA(x, ...)

\S4method{getPERMANOVA}{SingleCellExperiment}(x, ...)

\S4method{getPERMANOVA}{SummarizedExperiment}(x, assay.type = "counts", formula = NULL, col.var = NULL, ...)

\S4method{getPERMANOVA}{ANY}(x, formula, data, method = "bray", test.homogeneity = TRUE, ...)

\S4method{addPERMANOVA}{SummarizedExperiment}(x, name = "permanova", ...)
}
\arguments{
\item{x}{a \code{\link[SummarizedExperiment]{SummarizedExperiment}} object.}

\item{...}{additional arguments passed to \code{vegan::adonis2}.
\itemize{
\item \code{by}: \code{Character scalar}. Specifies how significance is
calculated. (Default: \code{"margin"})

\item \code{na.action}: \code{function}. Action to take when missing
values for any of the variables in \code{formula} are encountered.
(Default: \code{na.fail})

\item \code{full} \code{Logical scalar}. should all the results from the
homogeneity calculations be returned. When \code{FALSE}, only
summary tables are returned. (Default: \code{FALSE})

\item \code{homogeneity.test}: \code{Character scalar}. Specifies
the significance test used to analyse
\code{\link[vegan:betadisper]{vegan::betadisper}} results.
Options include 'permanova'
(\code{\link[vegan:permutest]{vegan::permutest}}), 'anova'
(\code{\link[stats:anova]{stats::anova}}) and 'tukeyhsd'
(\code{\link[stats:TukeyHSD]{stats::TukeyHSD}}).
(Default: \code{"permanova"})
}}

\item{assay.type}{\code{Character scalar}. Specifies the name of assay
used in calculation. (Default: \code{"counts"})}

\item{formula}{\code{formula}. If \code{x} is a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
a formula can be supplied. Based on the right-hand side of the given formula
\code{colData} is subset to \code{col.var}.

\code{col.var} and \code{formula} can be missing, which turns the CCA
analysis into a CA analysis and dbRDA into PCoA/MDS.}

\item{col.var}{\code{Character scalar}. When \code{x} is a
\code{SummarizedExperiment},\code{col.var} can be used to specify variables
from \code{colData}.}

\item{data}{\code{data.frame} or coarcible to one. The covariance table
including covariates defined by \code{formula}.}

\item{method}{\code{Character scalar}. A dissimilarity metric used in
PERMANOVA and group dispersion calculation. (Default: \code{"bray"})}

\item{test.homogeneity}{\code{Logical scalar}. Should the homogeneity of
group dispersions be evaluated? (Default: \code{TRUE})}

\item{name}{\code{Character scalar}. A name for the results that will be
stored to metadata. (Default: \code{"permanova"})}
}
\value{
\code{getPERMANOVA} returns the PERMANOVA results or a list containing the
PERMANOVA results and homogeneity test results if
\code{test.homogeneity = TRUE}. \code{addPERMANOVA} adds these results to
metadata of \code{x}.
}
\description{
These functions perform PERMANOVA to assess the significance of group
differences based on a specified dissimilarity matrix. The results can be
returned directly or added to metadata in an object of class
\code{TreeSummarizedExperiment}.
}
\details{
PERMANOVA is a non-parametric method used to test whether the centroids of
different groups (as defined by the formula or covariates) are significantly
different in terms of multivariate space.

PERMANOVA relies on the assumption of group homogeneity, meaning the groups
should be distinct and have similar variances within each group. This
assumption is essential as PERMANOVA is sensitive to differences in
within-group dispersion, which can otherwise confound results.
This is why the functions return homogeneity test results by default.

The functions utilize \code{\link[vegan:adonis2]{vegan::adonis2}} to compute
PERMANOVA. For homogeneity testing,
\code{\link[vegan:betadisper]{vegan::betadisper}} along
with \code{\link[vegan:permutest]{vegan::permutest}} are utilized by default,
which allow testing for equal dispersion across groups and validate the
homogeneity assumption.

PERMANOVA and distance-based redundancy analysis (dbRDA) are closely related
methods for analyzing multivariate data. PERMANOVA is non-parametric, making
fewer assumptions about the data. In contrast, dbRDA assumes a linear
relationship when constructing the ordination space, although it also
employs a PERMANOVA-like approach to test the significance of predictors
within this space. dbRDA offers a broader scope overall, as it provides
visualization of the constrained ordination, which can reveal patterns and
relationships. However, when the underlying data structure is non-linear,
the results from the two methods can differ significantly due to dbRDA's
reliance on linear assumptions.
}
\examples{

data(GlobalPatterns)
tse <- GlobalPatterns

# Apply relative transformation
tse <- transformAssay(tse, method = "relabundance")
# Perform PERMANOVA
tse <- addPERMANOVA(
    tse,
    assay.type = "relabundance",
    method = "bray",
    formula = x ~ SampleType,
    permutations = 99
    )
# The results are stored to metadata
metadata(tse)[["permanova"]]

# Calculate dbRDA
rda_res <- getRDA(
    tse, assay.type = "relabundance", method = "bray",
    formula = x ~ SampleType, permutations = 99)
# Significance results are similar to PERMANOVA
attr(rda_res, "significance")

}
\seealso{
For more details on the actual implementation see
\code{\link[vegan:adonis2]{vegan::adonis2}},
\code{\link[vegan:betadisper]{vegan::betadisper}}, and
\code{\link[vegan:permutest]{vegan::permutest}}. See also
\code{\link[=runCCA]{addCCA}} and \code{\link[=runCCA]{addRDA}}
}
