% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/convertFromPhyloseq.R,
%   R/convertToPhyloseq.R
\name{convertToPhyloseq}
\alias{convertToPhyloseq}
\alias{convertFromPhyloseq}
\alias{convertToPhyloseq,SummarizedExperiment-method}
\alias{convertToPhyloseq,TreeSummarizedExperiment-method}
\title{Create a \code{TreeSummarizedExperiment} object from a phyloseq object}
\usage{
convertToPhyloseq(x, ...)

convertFromPhyloseq(x)

\S4method{convertToPhyloseq}{SummarizedExperiment}(x, assay.type = "counts", assay_name = NULL, ...)

\S4method{convertToPhyloseq}{TreeSummarizedExperiment}(x, tree.name = tree_name, tree_name = "phylo", ...)
}
\arguments{
\item{x}{a
\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-class]{TreeSummarizedExperiment}}
object}

\item{...}{Additional arguments. Not used currently.}

\item{assay.type}{\code{Character scalar}. Specifies the name of assay
used. (Default: \code{"counts"})}

\item{assay_name}{Deprecated. Use \code{assay.type} instead.}

\item{tree.name}{\code{Character scalar}. Specifies the name of the
tree to be included in the phyloseq object that is created,
(Default: \code{"phylo"})}

\item{tree_name}{Deprecated. Use \code{tree.name} instead.}
}
\value{
\code{convertFromPhyloseq} returns an object of class
\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-class]{TreeSummarizedExperiment}}

\code{convertToPhyloseq} returns an object of class
\code{\link[phyloseq:phyloseq-class]{phyloseq}}
}
\description{
Create a \code{TreeSummarizedExperiment} object from a phyloseq object

Create a phyloseq object from a \code{TreeSummarizedExperiment} object
}
\details{
\code{convertFromPhyloseq} converts \code{phyloseq}
objects into
\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-class]{TreeSummarizedExperiment}} objects.
All data stored in a \code{phyloseq} object is transferred.

\code{convertToPhyloseq} creates a phyloseq object from a
\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-class]{TreeSummarizedExperiment}}
object. By using \code{assay.type}, it is possible to specify which table
from \code{assay} is added to the phyloseq object.
}
\examples{

### Coerce a phyloseq object to a TreeSE object
if (requireNamespace("phyloseq")) {
    data(GlobalPatterns, package="phyloseq")
    convertFromPhyloseq(GlobalPatterns)
    data(enterotype, package="phyloseq")
    convertFromPhyloseq(enterotype)
    data(esophagus, package="phyloseq")
    convertFromPhyloseq(esophagus)
}

### Coerce a TreeSE object to a phyloseq object
# Get tse object
data(GlobalPatterns)
tse <- GlobalPatterns

# Create a phyloseq object from it
phy <- convertToPhyloseq(tse)
phy

# By default the chosen table is counts, but if there are other tables,
# they can be chosen with assay.type.

# Counts relative abundances table
tse <- transformAssay(tse, method = "relabundance")
phy2 <- convertToPhyloseq(tse, assay.type = "relabundance")
phy2

}
