% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRSM.R
\name{share_miRs}
\alias{share_miRs}
\title{share_miRs}
\usage{
share_miRs(miRExp = NULL, miRTarget, Modulelist)
}
\arguments{
\item{miRExp}{NULL (default) or a SummarizedExperiment object. miRNA expression data: 
rows are samples and columns are miRNAs.}

\item{miRTarget}{A SummarizedExperiment object. Putative 
miRNA-target binding information.}

\item{Modulelist}{List object: a list of the identified miRNA sponge modules.}
}
\value{
List object: a list of common miRNAs of each miRNA sponge module.
}
\description{
Extract common miRNAs of each miRNA sponge module
}
\examples{
data(BRCASampleData)
modulegenes_WGCNA <- module_WGCNA(ceRExp, mRExp)
# Identify miRNA sponge modules using sensitivity RV coefficient (SRVC)
miRSM_WGCNA_SRVC <- miRSM(miRExp, ceRExp, mRExp, miRTarget,
                        modulegenes_WGCNA, method = "SRVC",
                        SMC.cutoff = 0.01, RV_method = "RV")
miRSM_WGCNA_SRVC_genes <- miRSM_WGCNA_SRVC[[2]]
miRSM_WGCNA_share_miRs <-  share_miRs(miRExp, miRTarget, miRSM_WGCNA_SRVC_genes)

}
\author{
Junpeng Zhang (\url{https://www.researchgate.net/profile/Junpeng-Zhang-2})
}
