% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRSM.R
\name{module_Validate}
\alias{module_Validate}
\title{module_Validate}
\usage{
module_Validate(Modulelist, Groundtruth)
}
\arguments{
\item{Modulelist}{List object: a list of the identified miRNA sponge modules.}

\item{Groundtruth}{Matrix object: a list of experimentally validated miRNA sponge interactions.}
}
\value{
List object: a list of validated miRNA sponge interactions in each miRNA sponge module
}
\description{
Validation of miRNA sponge interactions in each miRNA sponge module
}
\examples{
data(BRCASampleData)
modulegenes_WGCNA <- module_WGCNA(ceRExp, mRExp)
# Identify miRNA sponge modules using sensitivity RV coefficient (SRVC)
miRSM_WGCNA_SRVC <- miRSM(miRExp, ceRExp, mRExp, miRTarget,
                        modulegenes_WGCNA, method = "SRVC",
                        SMC.cutoff = 0.01, RV_method = "RV")
miRSM_WGCNA_SRVC_genes <- miRSM_WGCNA_SRVC[[2]]
Groundtruthcsv <- system.file("extdata", "Groundtruth_high.csv", package="miRSM")
Groundtruth <- read.csv(Groundtruthcsv, header=TRUE, sep=",") 
miRSM.Validate <- module_Validate(miRSM_WGCNA_SRVC_genes, Groundtruth)

}
\author{
Junpeng Zhang (\url{https://www.researchgate.net/profile/Junpeng-Zhang-2})
}
