% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRLAB.R
\name{ValidationT}
\alias{ValidationT}
\title{Validate the targets of a miRNA using transfection data}
\usage{
ValidationT(topkList, LFC)
}
\arguments{
\item{topkList}{a matrix with 3 columns. The first column is the miRNA name, the second contains the target mRNAs, and the third contains the correlation values/ causal effects/ scores}

\item{LFC}{the log fold change threshold. The targets that have the absolute value of log fold change greater than the LFC
will be regarded as the confirmed targets.}
}
\value{
a matrix in the same format of the input matrix put only contains the confirmed interactions.
}
\description{
Given the predicted target of a miRNA, the function returns a list of targets that are  confirmed
based on the curated transfection data. Users need to download the file logFC.imputed.rda from nugget.unisa.edu.au/Thuc/miRLAB/ and place it in the working directory (this file is obtained from the TargetScoreData package)
}
\examples{
print("ps=Pearson(dataset, cause=1:35, effect=36:1189)")
print("miR200aTop100=bRank(ps, 11, 100, TRUE)")
print("miR200aTop100Confirmed = ValidationT(miR200aTop100, 1.0)")
}
\references{
1. Le, T.D., Zhang, J., Liu, L., and Li, J. (2015) Ensemble Methods for miRNA Target Prediction from Expression Data, under review.

2. Li Y, Goldenberg A, Wong K and Zhang Z (2014). A probabilistic approach to explore human microRNA targetome using microRNA-overexpression data and sequence information. Bioinformatics, 30(5), pp. 621-628. http://dx.doi.org/10.1093/bioinformatics/btt599.
}
