% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRLAB.R
\name{Validation}
\alias{Validation}
\title{Validate the targets of a miRNA}
\usage{
Validation(topkList, datacsv)
}
\arguments{
\item{topkList}{a matrix with 3 columns. The first column is the miRNA name, the second contains the target mRNAs, and the third contains the correlation values/ causal effects/ scores}

\item{datacsv}{the ground truth for the validation. The ground truth is a matrix with 2 columns, where the first column
is the miRNA and the second is the mRNA.}
}
\value{
a matrix in the same format of the input matrix put only contains the confirmed interactions.
}
\description{
Given the predicted target of a miRNA, the function returns a list of targets that are experimentally confirmed
based on the provided ground truth. Users can provide their own ground truth or use the built-in ground truth 
which is the union of Tarbase, miRTarbase, miRecords, and miRWalk.
}
\examples{
dataset=system.file("extdata", "ToyEMT.csv", package="miRLAB")
ps=Pearson(dataset, cause=1:3, effect=4:18)
miR200aTop10=bRank(ps, 3, 10, TRUE)
groundtruth=system.file("extdata", "Toygroundtruth.csv", package="miRLAB")
miR200aTop10Confirmed = Validation(miR200aTop10, groundtruth)
}
