% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryPlots.R
\name{methyl_proportion}
\alias{methyl_proportion}
\title{Calculate the proportion of methylated bases for each cell/molecule}
\usage{
methyl_proportion(orderObject, type = "yellow", makePlot = TRUE, ...)
}
\arguments{
\item{orderObject}{An object of class \code{orderObject}}

\item{type}{Indicates which data set to compute proportions for.
This should be 'met' or 'hcg' or 'red' for endogenous methylation; 'acc' or
'gch' or 'yellow' for accessibility.}

\item{makePlot}{Indicates whether to plot a histogram of the proportions
across all cells/molcules.}

\item{...}{Additional parameters used by the \code{hist} function.}
}
\value{
The proportion of methylated (endogenous (yellow)
     or accessible) bases for each cell/molecule. Output is vector
     with length the numbner of cells/molecules and contains a proportion.
}
\description{
Calculate the proportion of methylated bases for each cell/molecule
}
\examples{

data(singlemolecule_example)

orderObj <- initialOrder(singlemolecule_example, Method = "PCA")
methyl_proportion(orderObj, makePlot = TRUE)
}
