% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tile_by_regions.R
\name{tile_by_regions}
\alias{tile_by_regions}
\title{Group cytosine / CpG level data into regions based on genomic regions}
\usage{
tile_by_regions(bs, gr)
}
\arguments{
\item{bs}{a \code{BSseq} object.}

\item{gr}{a \code{GRanges} object.}
}
\value{
A \code{BSseq} object with loci of regions matching \code{gr}. Coverage and methylation read count matrices are aggregated by the sums of the cytosines / CpGs in the regions per sample.
}
\description{
An optional function to aggregate cytosine / CpG level data into regions based on a \code{GRanges} set of genomic regions.
}
\examples{
data(bsseq_stranded, package = 'methylSig')
regions = GenomicRanges::GRanges(
    seqnames = c('chr1','chr1','chr1'),
    ranges = IRanges::IRanges(
        start = c(5,35,75),
        end = c(30,70,80)
    )
)
tiled = tile_by_regions(bs = bsseq_stranded, gr = regions)

}
