% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_loci_by_location.R
\name{filter_loci_by_location}
\alias{filter_loci_by_location}
\title{Remove loci by overlap with a \code{GRanges} object}
\usage{
filter_loci_by_location(bs, gr)
}
\arguments{
\item{bs}{a \code{BSseq} object.}

\item{gr}{a \code{GRanges} object.}
}
\value{
A \code{BSseq} object with loci intersecting \code{gr} removed.
}
\description{
A function to remove loci from a \code{BSseq} object based on intersection with loci in a \code{GRanges} object.
}
\examples{
data(bsseq_stranded, package = 'methylSig')
regions = GenomicRanges::GRanges(
    seqnames = c('chr1','chr1','chr1','chr1'),
    ranges = IRanges::IRanges(
        start = c(5,25,45,70),
        end = c(15,40,55,80)
    )
)
filtered = filter_loci_by_location(bs = bsseq_stranded, gr = regions)

}
