% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff_dss_fit.R
\name{diff_dss_fit}
\alias{diff_dss_fit}
\title{Performs model fit for general experimental design}
\usage{
diff_dss_fit(bs, design, formula)
}
\arguments{
\item{bs}{a \code{BSseq} object to calculate differential methylation statistics.}

\item{design}{a \code{data.frame} or \code{DataFrame} for experimental design. Should contain as many rows as there are columns (samples) in \code{bs}, and the order of the rows should match the columns of \code{bs}. If omitted, will default to \code{pData(bs)}.}

\item{formula}{a formula for the linear model. It should refer to column names from \code{design}. NOTE: The intercept is included by default if omitted. One can omit the intercept with a formula such as \code{'~ 0 + group'}. For clarity, it helps to include the intercept explicitly as in \code{'~ 1 + group'}.}
}
\value{
A \code{list} object with:
\describe{
    \item{gr:}{ a \code{GRanges} object with loci fit. }
    \item{design:}{ the \code{data.frame} input as the experimental design. }
    \item{formula:}{ the \code{formula} representing the model. Can be \code{character} or \code{formula}. }
    \item{X:}{ the design \code{matrix} used in regression based on the \code{design} and \code{formula}. This should be consulted to determine the appropriate contrast to use in \code{dss_fit_test()}. }
    \item{fit:}{ a \code{list} with model fitting results. It has components \code{beta}, the estimated coefficients, and \code{var.beta} the estimated variance/covariance matrix for \code{beta}. }
}
}
\description{
This function is a wrapper for \code{DSS::DMLfit.multiFactor}.
}
\examples{
data(BS.cancer.ex, package = 'bsseqData')

bs = filter_loci_by_group_coverage(
    bs = BS.cancer.ex,
    group_column = 'Type',
    c('cancer' = 2, 'normal' = 2))

small_test = bs[1:50]

diff_fit = diff_dss_fit(
    bs = small_test,
    design = bsseq::pData(bs),
    formula = '~ Type')

}
