% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylDBClasses.R
\docType{methods}
\name{readMethylDB}
\alias{readMethylDB}
\title{load tabix file with header to methylDB}
\usage{
readMethylDB(dbpath)
}
\arguments{
\item{dbpath}{path to a tabix file with header}
}
\value{
an \code{\link{methylBaseDB}},\code{\link{methylRawDB}},
\code{\link{methylRawListDB}} or an \code{\link{methylDiffDB}} object
}
\description{
The function reads the header from a given tabix file and 
loads it into corresponding methylDB object.
}
\examples{
\dontrun{
data(methylKit)

baseDB.obj <- makeMethylDB(methylBase.obj,"my/path")
mydbpath <- getDBPath(baseDB.obj)
rm(baseDB.obj)
readMethylDB(mydbpath)

}

}
