% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylInheritanceInternalMethods.R
\name{validateLoadConvergenceData}
\alias{validateLoadConvergenceData}
\title{Validation of some parameters of the
\code{\link{loadConvergenceData}} function}
\usage{
validateLoadConvergenceData(
  analysisResultsDir,
  permutationResultsDir,
  position,
  by
)
}
\arguments{
\item{analysisResultsDir}{a \code{character} string, the path to the
directory that contains the analysis results. The path can be the same as
for the \code{permutatioNResultsDir} parameter.}

\item{permutationResultsDir}{a \code{character} string, the path to the
directory that contains the permutation results. The path can be the same
as for the \code{analysisResultsDir} parameter.}

\item{position}{a positive \code{integer}, the position in the \code{list}
where the information will be extracted.}

\item{by}{a \code{integer}, the increment of the number of permutations
where the significant level is tested. Default: 100.}
}
\value{
\code{0} indicating that all parameters validations have been
successful.
}
\description{
Validation of some parameters needed by the public
\code{\link{loadConvergenceData}} function.
}
\examples{

## Get the name of the directory where files are stored
filesDir <- system.file("extdata", "TEST", package="methylInheritance")

## Merge permutation and observation results
methylInheritance:::validateLoadConvergenceData(analysisResultsDir =
    filesDir, permutationResults = filesDir, position = 1, by = 1)

## The function raises an error when at least one paramater is not valid
\dontrun{methylInheritance:::validateLoadConvergenceData(
    analysisResultsDir = filesDir, permutationResults = filesDir,
    position = "hello", by = 1))}

}
\author{
Astrid Deschenes, Pascal Belleau
}
\keyword{internal}
