% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methrix_operations.R
\name{region_filter}
\alias{region_filter}
\title{Filter matrices by region}
\usage{
region_filter(m, regions, type = "within")
}
\arguments{
\item{m}{\code{\link{methrix}} object}

\item{regions}{genomic regions to filter-out. Could be a data.table with 3 columns (chr, start, end) or a \code{GenomicRanges} object}

\item{type}{defines the type of the overlap of the CpG sites with the target regions. Default value is `within`. For detailed description,
see the \code{foverlaps} function of the \code{\link{data.table}} package.}
}
\value{
An object of class \code{\link{methrix}}
}
\description{
Filter matrices by region
}
\details{
Takes \code{\link{methrix}} object and filters CpGs based on supplied regions in data.table or GRanges format
}
\examples{
data('methrix_data')
region_filter(m = methrix_data,
regions = data.table(chr = 'chr21', start = 27867971, end =  27868103))
}
