% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methrix_plot.R
\name{plot_violin}
\alias{plot_violin}
\title{Violin Plot for \eqn{\beta}-Values}
\usage{
plot_violin(
  m,
  ranges = NULL,
  n_cpgs = 25000,
  pheno = NULL,
  col_palette = "RdYlGn"
)
}
\arguments{
\item{m}{Input \code{\link{methrix}} object}

\item{ranges}{genomic regions to be summarized. Could be a data.table with 3 columns (chr, start, end) or a \code{GenomicRanges} object}

\item{n_cpgs}{Use these many random CpGs for plotting. Default 25000. Set it to \code{NULL} to use all - which can be memory expensive.}

\item{pheno}{Column name of colData(m). Will be used as a factor to color different groups in the violin plot.}

\item{col_palette}{Name of the RColorBrewer palette to use for plotting.}
}
\value{
ggplot2 object
}
\description{
Violin Plot for \eqn{\beta}-Values
}
\examples{
data('methrix_data')
plot_violin(m = methrix_data)
}
