% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupedBerger.R
\name{groupedBerger}
\alias{groupedBerger}
\title{Combine grouped p-values with Berger's IUT}
\usage{
groupedBerger(p.values, grouping, log.p = FALSE)
}
\arguments{
\item{p.values}{A numeric vector containing p-values for individual tests.}

\item{grouping}{A vector or factor of length equal to \code{p.values}, specifying the group to which each test is assigned.

Alternatively, an \link{rle} object where each run corresponds to a group and specifies the entries of \code{p.values} belonging to that group.
This assumes that \code{p.values} is ordered such that all entries in the same group are adjacent to each other.}

\item{log.p}{Logical scalar indicating whether the p-values in \code{p.values} are log-transformed.}
}
\value{
A list containing:
\itemize{
\item \code{p.value}, a named numeric vector of length equal to the number of unique levels in \code{grouping}.
This contains the IUT p-value for each group, log-transformed if \code{log.p=TRUE}.
Each entry is named according to the group.
\item \code{representative}, a named integer vector containing the indices of the representative tests for each group.
Each index refers to an entry of \code{p.values} and is named according to its group.
\item \code{influential}, a logical vector of length equal to \code{p.values}.
Entries are \code{TRUE} for any p-value that is deemed \dQuote{influential} to the final combined p-value for its group.
}
}
\description{
Combine p-values from grouped tests with Berger's intersection-union test (IUT). 
Groups are defined according to unique levels of a grouping factor.
}
\details{
The joint null hypothesis for each group is that \emph{any} of the individual null hypotheses are true.
Berger's IUT will only reject the joint null if all of the individual nulls are rejected.
This method is applicable under arbitrary dependency structures.
No weights are considered.

The representative test for each group is defined as the test with the largest p-value, as this is ultimately used as the IUT p-value.
All tests for each group are considered to be influential as increasing any of them (e.g., to unity) would result in a larger combined p-value.
}
\examples{
p1 <- rbeta(100, 0.8, 1)
g <- sample(10, length(p1), replace=TRUE)

# Standard application:
out <- groupedBerger(p1, g)
str(out)

# With log p-values. 
out <- groupedBerger(log(p1), g, log.p=TRUE)
str(out)

}
\references{
Berger RL and Hsu JC (1996).
Bioequivalence trials, intersection-union tests and equivalence confidence sets.
\emph{Statist. Sci.} 11, 283-319.
}
\seealso{
\code{\link{parallelBerger}}, for a version that operates on parallel vectors of p-values.
}
\author{
Aaron Lun
}
