% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap_from_metagene.R
\name{coverage_order}
\alias{coverage_order}
\title{Determines ordering of regions as a function of coverage.}
\usage{
coverage_order(metagene, design_groups = NULL, decreasing = TRUE)
}
\arguments{
\item{metagene}{The metagene object whose grouped regions should be ordered.}

\item{design_groups}{A vector of design groups to be used for determining the 
ordering. If \code{NULL}, all design groups are used.}

\item{decreasing}{If TRUE, regions are ordered from the highest mean coverage
to the lowest mean coverage, and vice versa.}
}
\value{
A list, with as many elements as there are region groups in the
        metagene object. Each element of that list is an ordering of the
        regions of that group based on their mean coverage.
}
\description{
This function creates an ordering of regions within region groups based on 
ascending or descending mean coverage. This is used with the 
\code{\link{metagene2_heatmap}} function.
}
\examples{
  demo_metagene = get_demo_metagene()
  coverage_order(demo_metagene)
}
