% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/methods-metabData.R
\name{filtered}
\alias{filtered}
\alias{filtered,metabData-method}
\title{Retrieve Filtered Features}
\usage{
filtered(object, type = c("rt", "duplicates", "missing"))

\S4method{filtered}{metabData}(object, type = c("rt", "missing", "duplicates"))
}
\arguments{
\item{object}{\code{metabData} object}

\item{type}{one of three filter types used for feature removal}
}
\value{
data frame of features removed due to specified filter
}
\description{
Returns a data frame of metabolomics features eliminated in the
\code{\link{metabData}} step. Features are returned based on the specific
filter used for their elimination (RT, missingness, or duplicates).
}
\examples{
data(plasma20)

p20 <- metabData(plasma20, samples = "CHEAR", zero = TRUE, misspc = 20,
                  rtmax = 17)

filtered_by_rt <- filtered(p20, type = "rt")

filtered_by_missingness <- filtered(p20, type = "missing")

}
