meta.oneside.noiseq <-
function (input, k = 0.5, norm = c("rpkm", "uqua", "tmm", "n"), 
    replicates = c("technical", "biological", "no"), factor = NULL, 
    conditions = NULL, pnr = 0.2, nss = 5, v = 0.02, lc = 1, 
    studies = NULL, cl = NULL) 
{
    if (inherits(input, "metaExpressionSet") == FALSE) {
        stop("Error. You must give an object generated by the meta.readData function or other.oneside.pvalues\n")
    }
    if (is.null(studies)) {
        stop("Please specify \"studies\" at first!\n")
    }
    else if (!is.vector(factor)) {
        stop("Please \"factor\" parameter as vector.\n")
    }
    else if (!is.vector(studies)) {
        stop("Please \"studies\" parameter as vector.\n")
    }
    else if (length(factor) != length(studies)) {
        stop("Length of factors and that of studies are different!\n")
    }
    else {
        out <- list()
        l <- length(input)
        length(out) <- l
        k2 = 0.5
        norm2 = c("rpkm", "uqua", "tmm", "n")
        replicates2 = c("technical", "biological", "no")
        conditions2 = NULL
        pnr2 = 0.2
        nss2 = 5
        v2 = 0.02
        lc2 = 1
        if (k != 0.5) {
            k2 <- k
        }
        if (length(norm) != 4) {
            norm2 <- norm
        }
        if (length(replicates) != 3) {
            replicates2 <- replicates
        }
        if (!is.null(conditions)) {
            conditions2 <- conditions
        }
        if (pnr != 0.2) {
            pnr2 <- pnr
        }
        if (nss != 5) {
            nss2 <- nss
        }
        if (v != 0.02) {
            v2 <- v
        }
        if (lc != 1) {
            lc2 <- lc
        }
        e <<- new.env()
        e$input <- input
        e$factors <- factor
        e$studies <- studies
        e$k <- k2
        e$norm <- norm2
        e$replicates <- replicates2
        e$conditions <- conditions2
        e$pnr <- pnr2
        e$nss <- nss2
        e$v <- v2
        e$lc <- lc2
        loc <- list()
        length(loc) <- l
        e$loc <- loc
        for (x in 1:l) {
            e$loc[[x]] <- which(levels(as.factor(e$studies))[x] == 
                e$studies)
        }
        if (!is.null(cl)) {
            clusterExport(cl, "e")
            out <- snow::parSapply(cl, 1:l, function(x) {
                output <- list()
                length(output) <- 3
                names(output) <- c("upper", "lower", "weight")
                result <- metaSeq:::oneside.noiseq(e$input[[x]], 
                  k = e$k, norm = e$norm, replicates = e$replicates, 
                  factor = "e$factors[e$loc[[x]]]", conditions = e$conditions, 
                  pnr = e$pnr, nss = e$nss, v = e$v, lc = e$lc, 
                  x = x)
                U <- result@results[[1]]$prob
                L <- 1 - result@results[[1]]$prob
                W <- nrow(input[[x]]@phenoData@data)
                names(U) <- rownames(input[[x]]@assayData$exprs)
                names(L) <- rownames(input[[x]]@assayData$exprs)
                output$upper <- U
                output$lower <- L
                output$weight <- W
                return(output)
            })
            colnames(out) <- paste("Study", 1:l)
            return(out)
        }
        else {
            out <- sapply(1:l, function(x) {
                output <- list()
                length(output) <- 3
                names(output) <- c("upper", "lower", "weight")
                result <- metaSeq:::oneside.noiseq(e$input[[x]], 
                  k = e$k, norm = e$norm, replicates = e$replicates, 
                  factor = "e$factors[e$loc[[x]]]", conditions = e$conditions, 
                  pnr = e$pnr, nss = e$nss, v = e$v, lc = e$lc, 
                  x = x)
                U <- result@results[[1]]$prob
                L <- 1 - result@results[[1]]$prob
                W <- nrow(input[[x]]@phenoData@data)
                names(U) <- rownames(input[[x]]@assayData$exprs)
                names(L) <- rownames(input[[x]]@assayData$exprs)
                output$upper <- U
                output$lower <- L
                output$weight <- W
                return(output)
            })
            colnames(out) <- paste("Study", 1:l)
            return(out)
        }
    }
}
