% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{meme_is_installed}
\alias{meme_is_installed}
\title{Returns logical vector indicating valid MEME-Suite install status}
\usage{
meme_is_installed(path = NULL)
}
\arguments{
\item{path}{optional path to "meme/bin/". If unset, will follow the search
heirarchy listed above.}
}
\value{
\code{logical(1)} indicating whether meme is installed with all supported utilities
}
\description{
Checks for a valid meme install using same heirarchy as \code{check_meme_install()}.
Returns \code{TRUE} if all supported utilities are found in the meme install
location, \code{FALSE} if not.
}
\details{
The search heirarchy is as follows:
\enumerate{
\item the \code{meme_path} function argument if set
\item the \code{meme_bin} option
\item the \code{MEME_BIN} environment variable
\item the default location at \verb{~/meme/bin}
}
}
\examples{
meme_is_installed()
}
\seealso{
\code{\link[=check_meme_install]{check_meme_install()}}
}
