% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_labels.R
\name{predict_mini_batch_r}
\alias{predict_mini_batch_r}
\title{Compute labels for mini-batch k-means}
\usage{
predict_mini_batch_r(
  data,
  centroids,
  BPPARAM = BiocParallel::SerialParam(),
  ...
)
}
\arguments{
\item{data}{a matrix-like object with features in row and samples in columns.}

\item{centroids}{a matrix with the coordinates of the centroids.}

\item{BPPARAM}{for parallel computations. See the `BiocParallel` package.}

\item{...}{passed to `blockApply`.}
}
\value{
a vector of cluster labels for each observation.
}
\description{
Given a data matrix and a centroid matrix, it assigns each data point to the
closest centroid, using block processing.
}
\examples{

data(iris)
km <- mini_batch(as.matrix(iris[,1:4]), clusters = 3,
                 batch_size = 10, max_iters = 100)
predict_mini_batch_r(t(as.matrix(iris[,1:4])), km$centroids)
}
