% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{MarrPlotSamplepairs}
\alias{MarrPlotSamplepairs}
\title{Plot percent reproducible features per sample pair
for pairwise replicates from \code{Marr} function.}
\usage{
MarrPlotSamplepairs(
  object,
  xLab = "Percent reproducible features per sample pair",
  yLab = "Sample pair"
)
}
\arguments{
\item{object}{a Marr object from \code{Marr}}

\item{xLab}{label for x-axis.
Default is 'Percent reproducible features
 per sample pair for pairwise replicates'.}

\item{yLab}{label for y-axis. Default is 'Sample pair'}
}
\value{
A histogram will be created showing the
sample pairs along the y-axis and percent reproducible features
per sample pair on the x-axis.
}
\description{
This function plots a histogram
showing the sample pairs along the y-axis
and percent reproducible features per sample pair on
the x-axis.
}
\examples{
data <- matrix(rnorm(2400), nrow=200, ncol=12)
data_Marr <- Marr(object = data, pSamplepairs=0.75,
                  pFeatures=0.75, alpha=0.05)
MarrPlotSamplepairs(data_Marr)

}
