% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROCAUC_Scores.R
\name{ROCAUC_Scores_Calculate}
\alias{ROCAUC_Scores_Calculate}
\title{Compute ROC Curves and AUC Values for Gene Signature Scores}
\usage{
ROCAUC_Scores_Calculate(
  data,
  metadata,
  gene_sets,
  method = c("logmedian", "ssGSEA", "ranking", "all"),
  variable,
  mode = c("simple", "medium", "extensive")
)
}
\arguments{
\item{data}{A matrix or data frame of gene expression data (genes as rows,
samples as columns).}

\item{metadata}{A data frame containing sample metadata, including the
grouping variable.}

\item{gene_sets}{A named list of gene sets, where each entry is a character
vector of gene names.}

\item{method}{A character string specifying the score calculation method.
Options: \code{"logmedian"}, \code{"ssGSEA"}, \code{"ranking"}, or \code{"all"}.}

\item{variable}{A character string specifying the categorical variable for
group comparisons.#'}

\item{mode}{A string specifying the level of detail for contrasts. Options
are:
\itemize{
\item \code{"simple"}: Pairwise comparisons (e.g., A - B).
\item \code{"medium"}: Pairwise comparisons plus comparisons against the mean of other groups.
\item \code{"extensive"}: All possible groupwise contrasts, ensuring balance in the number of terms on each side.
}}
}
\value{
A named list containing ROC curve data and AUC values for each
method, signature, and contrast.
}
\description{
This function calculates Receiver Operating Characteristic (ROC) curves and
Area Under the Curve (AUC) values for gene signature scores across different
contrasts of a given categorical variable.
}
\keyword{internal}
