% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods-changePixelRes.R
\name{selectPixel}
\alias{selectPixel}
\alias{selectPixel,InteractionArray-method}
\title{Get the pixel representing the strongest
or weakest interaction in an InteractionArray}
\usage{
selectPixel(
  x,
  aggFUN = sum,
  selectFUN = "which.max",
  nBlocks = 5,
  verbose = TRUE
)

\S4method{selectPixel}{InteractionArray}(
  x,
  aggFUN = sum,
  selectFUN = "which.max",
  nBlocks = 5,
  verbose = TRUE
)
}
\arguments{
\item{x}{InteractionArray object}

\item{aggFUN}{Function to use for aggregating
across Hi-C files. Must be passable to
`which.max` or `which.min`. Default is "sum".}

\item{selectFUN}{Function to use for selecting
among aggregated interactions. Must be one of
"which.max" or "which.min".}

\item{nBlocks}{Number of blocks for block-processing
arrays. Default is 5. Increase this for large
datasets. To read and process all data at once, set
this value to 1.}

\item{verbose}{Boolean (TRUE or FALSE) describing
whether to report block-processing progress. Default
is TRUE.}
}
\value{
A GInteractions object with the updated
 pixel interactions, along with a column with the
 aggregated max/min value for that pixel.
}
\description{
Get the pixel representing the strongest
or weakest interaction in an InteractionArray
}
\examples{
## Load marinerData
if (!require("marinerData", quietly = TRUE))
    BiocManager::install("marinerData")

## Read .hic file paths
hicFiles <- c(
    marinerData::LEUK_HEK_PJA27_inter_30.hic(),
    marinerData::LEUK_HEK_PJA30_inter_30.hic()
)
names(hicFiles) <- c("FS", "WT")

## Read in loops as GInteractions object
loops <-
    WT_5kbLoops.txt() |>
    setNames("WT") |>
    read.table(header=TRUE) |>
    as_ginteractions(keep.extra.columns=FALSE)

## Removes the "chr" prefix for compatibility
## with the preprocessed hic files
GenomeInfoDb::seqlevelsStyle(loops) <- 'ENSEMBL'

## Rebin loops to 2.5e6 resolution
loops <- assignToBins(x=loops, binSize=2.5e06)

## Pull 5x5 matrices
iarr <- pullHicMatrices(x=loops[1:5],
                        files=hicFiles,
                        binSize=500e3,
                        norm="KR",
                        half='upper')

## Select pixel
selectPixel(iarr)

}
