% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods-pullHic.R
\name{pullHicPixels}
\alias{pullHicPixels}
\alias{pullHicPixels,GInteractions,character,numeric-method}
\title{Pull contact frequency from `.hic` files}
\usage{
pullHicPixels(
  x,
  files,
  binSize,
  ...,
  h5File = tempfile(fileext = ".h5"),
  half = "both",
  norm = "NONE",
  matrix = "observed",
  blockSize = 248956422,
  onDisk = TRUE,
  compressionLevel = 0,
  chunkSize = 1
)

\S4method{pullHicPixels}{GInteractions,character,numeric}(
  x,
  files,
  binSize,
  h5File,
  half,
  norm,
  matrix,
  blockSize,
  onDisk,
  compressionLevel,
  chunkSize
)
}
\arguments{
\item{x}{GInteractions object containing interactions
to extract from Hi-C files.}

\item{files}{Character file paths to `.hic` files.}

\item{binSize}{Integer (numeric) describing the
resolution (range widths) of the paired data.}

\item{...}{Additional arguments.}

\item{h5File}{Character file path to save `.h5` file.}

\item{half}{String (character vector of length one)
indicating whether to keep values for the upper
triangular (`half="upper"`) where `start1 < start2`,
lower triangular (`half="lower"`) where
`start1 > start2`, or both (`half="both"`, default).
When `half="upper"` all lower triangular values are `NA`.
When `half="lower"` all upper triangular values are `NA`.
When `half="both"` there are no `NA` values.
For interchromosomal interactions there is no inherent
directionality between chromosomes, so data is returned
regardless of specified order.}

\item{norm}{String (length one character vector)
describing the Hi-C normalization to apply. Use
`strawr::readHicNormTypes()` to see accepted values
for each file in `files`.}

\item{matrix}{String (length one character vector)
Type of matrix to extract. Must be one of "observed",
"oe", or "expected". "observed" is observed counts,
"oe" is observed/expected counts, "expected" is
expected counts.}

\item{blockSize}{Number (length one numeric vector)
describing the size in base-pairs to pull from each
`.hic` file. Default is 248956422 (the length of the
longest chromosome in the human hg38 genome). For
large `.hic` files `blockSize` can be reduced to
conserve the amount of data read in at a time. Larger
`blockSize` values speed up performance, but use more
memory.}

\item{onDisk}{Boolean (length one logical vector that
is not NA) indicating whether extracted data should
be stored on disk in an HDF5 file. Default is TRUE.}

\item{compressionLevel}{Number (length one numeric vector)
between 0 (Default) and 9 indicating the compression
level used on HDF5 file.}

\item{chunkSize}{Number (length one numeric vector)
indicating how many values of `x` to chunk for each
write to HDF5 stored data. This has downstream
implications for accessing subsets later. For small
`compressionLevel` values use smaller `chunkSize`
values and for large `compressionLevel` values use large
(i.e. `length(x)`) values to improve performance.}
}
\value{
InteractionSet object with a 2-dimensional array
 of Hi-C interactions (rows) and Hi-C sample (columns).
}
\description{
Pull contact frequency from `.hic` files
}
\examples{
## Load marinerData
if (!require("marinerData", quietly = TRUE))
    BiocManager::install("marinerData")

## Read .hic file paths
hicFiles <- c(
    marinerData::LEUK_HEK_PJA27_inter_30.hic(),
    marinerData::LEUK_HEK_PJA30_inter_30.hic()
)
names(hicFiles) <- c("FS", "WT")

## Read in loop pixels as GInteractions object
pixels <-
  WT_5kbLoops.txt() |>
  setNames("WT") |>
  read.table(header=TRUE) |>
  as_ginteractions(keep.extra.columns=FALSE) |>
  assignToBins(binSize=100e3)

## Removes the "chr" prefix for compatibility
## with the preprocessed hic files
GenomeInfoDb::seqlevelsStyle(pixels) <- 'ENSEMBL'

## Extract the first 100 pixels
imat <- pullHicPixels(x=pixels[1:100],
                      files=hicFiles,
                      binSize=100e3)
imat

## Access count matrix
counts(imat)

}
