% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods-mergePairs.R
\name{mergePairs}
\alias{mergePairs}
\alias{mergePairs,list_OR_SimpleList_OR_GInteractions,numeric-method}
\title{Merge sets of paired interactions}
\usage{
mergePairs(
  x,
  radius,
  method = "manhattan",
  column = NULL,
  selectMax = TRUE,
  pos = "center"
)

\S4method{mergePairs}{list_OR_SimpleList_OR_GInteractions,numeric}(
  x,
  radius,
  method = "manhattan",
  column = NULL,
  selectMax = TRUE,
  pos = "center"
)
}
\arguments{
\item{x}{List of `GInteractions` or `data.frame`-like
objects.}

\item{radius}{Numeric describing the distance in base
pairs used to define a cluster or pairs.}

\item{method}{Character describing the distance measure
to be used. This must be one of "euclidean", "maximum",
"manhattan", "canberra", "binary" or "minkowski".
Any unambiguous substring can be given.
Default is "manhattan".}

\item{column}{Character denoting the column to be used
to select among clustered interactions.}

\item{selectMax}{Logical. TRUE (default) uses `which.max()`
to select the interaction pair. FALSE uses `which.min()`.
Only applicable when `column` is specified.}

\item{pos}{Positions used for clustering pairs. Must be
one of "start", "end" or "center". Default is "center".}
}
\value{
Returns a `MergedGInteractions` object.
}
\description{
Sets of paired range objects (i.e., `GInteractions`)
are first clustered by genomic distance with `dbscan`,
then a representative interaction is selected for
each cluster.
}
\details{
Interactions are clustered into groups using the
provided base pair `radius`, and distance `method`
with `dbscan()`. Representative interactions are
selected for each group by one of two methods.
If `column` and `selectMax` arguments are provided,
the representative interaction with the maximum
(or minimum) value in `column` is returned for each
cluster. If these parameters are missing, new ranges
for each pair are returned by calculating the median
of modes for each cluster.
}
\examples{
## Load marinerData
if (!require("marinerData", quietly = TRUE))
    BiocManager::install("marinerData")

bedpeFiles <- c(
    marinerData::FS_5kbLoops.txt(),
    marinerData::WT_5kbLoops.txt()
)
names(bedpeFiles) <- c("FS", "WT")

## Read in bedpeFiles as a list of GInteractions
## Use only first 1000 rows for fast example
giList <-
    lapply(bedpeFiles, read.table, header=TRUE, nrows=1000) |>
    lapply(as_ginteractions)

## Cluster & merge pairs
x <- mergePairs(x = giList,
                radius = 10e03,
                column = "APScoreAvg")
x

}
