% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods-GInteractions.R
\name{seqnames1}
\alias{seqnames1}
\alias{seqnames2}
\alias{start1}
\alias{end1}
\alias{start2}
\alias{end2}
\alias{seqnames1,GInteractions_OR_InteractionSet-method}
\alias{seqnames2,GInteractions_OR_InteractionSet-method}
\alias{start1,GInteractions_OR_InteractionSet-method}
\alias{end1,GInteractions_OR_InteractionSet-method}
\alias{start2,GInteractions_OR_InteractionSet-method}
\alias{end2,GInteractions_OR_InteractionSet-method}
\title{Access each portion of a GInteractions-like object}
\usage{
seqnames1(x, ...)

seqnames2(x, ...)

start1(x, ...)

end1(x, ...)

start2(x, ...)

end2(x, ...)

\S4method{seqnames1}{GInteractions_OR_InteractionSet}(x)

\S4method{seqnames2}{GInteractions_OR_InteractionSet}(x)

\S4method{start1}{GInteractions_OR_InteractionSet}(x)

\S4method{end1}{GInteractions_OR_InteractionSet}(x)

\S4method{start2}{GInteractions_OR_InteractionSet}(x)

\S4method{end2}{GInteractions_OR_InteractionSet}(x)
}
\arguments{
\item{x}{GInteractions object.}

\item{...}{Additional arguments.}
}
\value{
A vector of values corresponding to the
 requested component of a GInteractions-like object.
 For seqnames1 and seqnames2 the RLE is coerced to a
 character vector.
}
\description{
Access each portion of a GInteractions-like object
}
\examples{
library(InteractionSet)
## Create example reference interactions objects
gi <- read.table(text="
    chr1 10 20 chr1 50 60
    chr2 30 40 chr2 60 70
    chr1 50 60 chr3 10 20") |>
    as_ginteractions()

iset <- InteractionSet(assays=matrix(nrow=3),
                       interactions=gi)

## Access vectors of values
seqnames1(gi)
start1(gi)
end1(gi)
seqnames2(gi)
start2(gi)
end2(gi)

## Also works for InteractionSet-like objects
seqnames1(iset)
start1(iset)
end1(iset)
seqnames2(iset)
start2(iset)
end2(iset)

}
