% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAll.R
\name{plotAll}
\alias{plotAll}
\title{All plots of power evaulation results under various scenarios.}
\usage{
plotAll(Power.list, depth_factor = 1)
}
\arguments{
\item{Power.list}{A list produced by \code{\link{powerEval}}.}

\item{depth_factor}{A numerical value indicating which sequencing depth to plot. For example, 2 means doubling the original sequencing depth. Default is 1.}
}
\value{
It plots all power measurements of a certain sequencing depth in a 2x2 panel. Power measurements to plot include "FDR", "FDC", "Power", and "Precision".
}
\description{
This function plots all power measurements of a certain sequencing depth in a 2x2 panel. Power measurements to plot include "FDR", "FDC", "Power", and "Precision".
}
\examples{

library(magpie)
### Main function
power.test <- quickPower(dataset = "GSE46705", test_method = "TRESS")

### plot all in a panel under sequencing depth 1x
plotAll(power.test, depth_factor = 1)

}
