% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oncoplot.R
\name{oncoplot}
\alias{oncoplot}
\title{draw an oncoplot}
\usage{
oncoplot(
  maf,
  top = 20,
  minMut = NULL,
  genes = NULL,
  altered = FALSE,
  drawRowBar = TRUE,
  drawColBar = TRUE,
  leftBarData = NULL,
  leftBarLims = NULL,
  leftBarVline = NULL,
  leftBarVlineCol = "gray70",
  rightBarData = NULL,
  rightBarLims = NULL,
  rightBarVline = NULL,
  rightBarVlineCol = "gray70",
  topBarData = NULL,
  topBarLims = NULL,
  topBarHline = NULL,
  topBarHlineCol = "gray70",
  logColBar = FALSE,
  includeColBarCN = TRUE,
  clinicalFeatures = NULL,
  annotationColor = NULL,
  annotationDat = NULL,
  pathways = NULL,
  topPathways = 3,
  path_order = NULL,
  selectedPathways = NULL,
  collapsePathway = FALSE,
  pwLineCol = "#535c68",
  pwLineWd = 1,
  draw_titv = FALSE,
  titv_col = NULL,
  showTumorSampleBarcodes = FALSE,
  tsbToPIDs = NULL,
  barcode_mar = 4,
  barcodeSrt = 90,
  gene_mar = 5,
  anno_height = 1,
  legend_height = 4,
  sortByAnnotation = FALSE,
  groupAnnotationBySize = TRUE,
  annotationOrder = NULL,
  sortByMutation = FALSE,
  keepGeneOrder = FALSE,
  GeneOrderSort = TRUE,
  sampleOrder = NULL,
  additionalFeature = NULL,
  additionalFeaturePch = 20,
  additionalFeatureCol = "gray70",
  additionalFeatureCex = 0.9,
  genesToIgnore = NULL,
  removeNonMutated = FALSE,
  fill = TRUE,
  cohortSize = NULL,
  colors = NULL,
  cBioPortal = FALSE,
  bgCol = "#ecf0f1",
  borderCol = "white",
  annoBorderCol = NA,
  numericAnnoCol = NULL,
  drawBox = FALSE,
  fontSize = 0.8,
  SampleNamefontSize = 1,
  titleFontSize = 1.5,
  legendFontSize = 1.2,
  annotationFontSize = 1.2,
  sepwd_genes = 0.5,
  sepwd_samples = 0.25,
  writeMatrix = FALSE,
  colbar_pathway = FALSE,
  showTitle = TRUE,
  titleText = NULL,
  showPct = TRUE
)
}
\arguments{
\item{maf}{an \code{\link{MAF}} object generated by \code{\link{read.maf}}}

\item{top}{how many top genes to be drawn. defaults to 20.}

\item{minMut}{draw all genes with `min` number of mutations. Can be an integer or fraction (of samples mutated), Default NULL}

\item{genes}{Just draw oncoplot for these genes. Default NULL.}

\item{altered}{Default FALSE. Chooses top genes based on muatation status. If \code{TRUE} chooses top genes based alterations (CNV or mutation).}

\item{drawRowBar}{logical. Plots righ barplot for each gene. Default \code{TRUE}.}

\item{drawColBar}{logical plots top barplot for each sample. Default \code{TRUE}.}

\item{leftBarData}{Data for leftside barplot. Must be a data.frame with two columns containing gene names and values. Default `NULL`}

\item{leftBarLims}{limits for `leftBarData`. Default `NULL`.}

\item{leftBarVline}{Draw vertical lines at these values. Default `NULL`.}

\item{leftBarVlineCol}{Line color for `leftBarVline` Default gray70}

\item{rightBarData}{Data for rightside barplot. Must be a data.frame with two columns containing to gene names and values. Default `NULL` which draws distribution by variant classification. This option is applicable when only `drawRowBar` is TRUE.}

\item{rightBarLims}{limits for `rightBarData`. Default `NULL`.}

\item{rightBarVline}{Draw vertical lines at these values. Default `NULL`.}

\item{rightBarVlineCol}{Line color for `rightBarVline` Default gray70}

\item{topBarData}{Default `NULL` which draws absolute number of mutation load for each sample. Can be overridden by choosing one clinical indicator(Numeric) or by providing a two column data.frame containing sample names and values for each sample. This option is applicable when only `drawColBar` is TRUE.}

\item{topBarLims}{limits for `topBarData`. Default `NULL`.}

\item{topBarHline}{Draw horizontal lines at these values. Default `NULL`.}

\item{topBarHlineCol}{Line color for `topBarHline.` Default gray70}

\item{logColBar}{Plot top bar plot on log10 scale. Default \code{FALSE}.}

\item{includeColBarCN}{Whether to include CN in column bar plot. Default TRUE}

\item{clinicalFeatures}{columns names from `clinical.data` slot of \code{MAF} to be drawn in the plot. Default NULL.}

\item{annotationColor}{Custom colors to use for `clinicalFeatures`. Must be a named list containing a named vector of colors. Default NULL. See example for more info.}

\item{annotationDat}{If MAF file was read without clinical data, provide a custom \code{data.frame} with a column \code{Tumor_Sample_Barcode} containing sample names along with rest of columns with annotations.
You can specify which columns to be drawn using `clinicalFeatures` argument.}

\item{pathways}{Default `NULL`. Can be `sigpw`, `smgbp`, or a two column data.frame/tsv-file with genes and corresponding pathway mappings.`}

\item{topPathways}{Top most altered pathways to draw. Default 3. Mutually exclusive with `selectedPathways`}

\item{path_order}{Default `NULL` Manually specify the order of pathways}

\item{selectedPathways}{Manually provide the subset of pathway names to be selected from `pathways`. Default NULL. In case `pathways` is `auto` draws top 3 altered pathways.}

\item{collapsePathway}{Shows only rows corresponding to the pathways. Default FALSE.}

\item{pwLineCol}{Color for the box around the pathways Default #535c68}

\item{pwLineWd}{Line width for the box around the pathways Default Default 1}

\item{draw_titv}{logical Includes TiTv plot. \code{FALSE}}

\item{titv_col}{named vector of colors for each transition and transversion classes. Should be of length six with the names "C>T" "C>G" "C>A" "T>A" "T>C" "T>G".  Default NULL.}

\item{showTumorSampleBarcodes}{logical to include sample names.}

\item{tsbToPIDs}{Custom names for Tumor_Sample_Barcodes. Can be a column name in clinicaldata or a 2 column data.frame of Tumor_Sample_Barcodes to patient ID mappings. Applicable only when `showTumorSampleBarcodes = TRUE`. Default NULL.}

\item{barcode_mar}{Margin width for sample names. Default 4}

\item{barcodeSrt}{Rotate sample labels. Default 90.}

\item{gene_mar}{Margin width for gene names. Default 5}

\item{anno_height}{Height of plotting area for sample annotations. Default 1}

\item{legend_height}{Height of plotting area for legend. Default 4}

\item{sortByAnnotation}{logical sort oncomatrix (samples) by provided `clinicalFeatures`. Sorts based on first `clinicalFeatures`.  Defaults to FALSE. column-sort}

\item{groupAnnotationBySize}{Further group `sortByAnnotation` orders by their size.  Defaults to TRUE. Largest groups comes first.}

\item{annotationOrder}{Manually specify order for annotations. Works only for first `clinicalFeatures`. Default NULL.}

\item{sortByMutation}{Force sort matrix according mutations. Helpful in case of MAF was read along with copy number data. Default FALSE.}

\item{keepGeneOrder}{logical whether to keep order of given genes. Default FALSE, order according to mutation frequency}

\item{GeneOrderSort}{logical this is applicable when `keepGeneOrder` is TRUE. Default TRUE}

\item{sampleOrder}{Manually speify sample names for oncolplot ordering. Default NULL.}

\item{additionalFeature}{a vector of length two indicating column name in the MAF and the factor level to be highlighted. Provide a list of values for highlighting more than one features}

\item{additionalFeaturePch}{Default 20}

\item{additionalFeatureCol}{Default "gray70"}

\item{additionalFeatureCex}{Default 0.9}

\item{genesToIgnore}{do not show these genes in Oncoplot. Default NULL.}

\item{removeNonMutated}{Logical. If \code{TRUE} removes samples with no mutations in the oncoplot for better visualization. Default \code{FALSE}.}

\item{fill}{Logical. If \code{TRUE} draws genes and samples as blank grids even when they are not altered.}

\item{cohortSize}{Number of sequenced samples in the cohort. Default all samples from Cohort. You can manually specify the cohort size. Default \code{NULL}}

\item{colors}{named vector of colors for each Variant_Classification.}

\item{cBioPortal}{Adds annotations similar to cBioPortals MutationMapper and collapse Variants into Truncating and rest.}

\item{bgCol}{Background grid color for wild-type (not-mutated) samples. Default "#ecf0f1"}

\item{borderCol}{border grid color (not-mutated) samples. Default 'white'.}

\item{annoBorderCol}{border grid color for annotations. Default NA.}

\item{numericAnnoCol}{color palette used for numeric annotations. Default 'YlOrBr' from RColorBrewer}

\item{drawBox}{logical whether to draw a box around main matrix. Default FALSE}

\item{fontSize}{font size for gene names. Default 0.8.}

\item{SampleNamefontSize}{font size for sample names. Default 1}

\item{titleFontSize}{font size for title. Default 1.5}

\item{legendFontSize}{font size for legend. Default 1.2}

\item{annotationFontSize}{font size for annotations. Default 1.2}

\item{sepwd_genes}{size of lines seperating genes. Default 0.5}

\item{sepwd_samples}{size of lines seperating samples. Default 0.25}

\item{writeMatrix}{writes character coded matrix used to generate the plot to an output file.}

\item{colbar_pathway}{Draw top column bar with respect to diplayed pathway. Default FALSE.}

\item{showTitle}{Default TRUE}

\item{titleText}{Custom title. Default `NULL`}

\item{showPct}{Default TRUE. Shows percent altered to the right side of the plot.}
}
\value{
Invisibly returns a list with components
1. `oncomatrix` A matrix used for drawing the oncoplot. Values are numeric coded for each variant classification
2. `vc_legend` A mapping of variant classification to numeric values in the oncomatrix
3. `vc_color` Color coding used for each variant classification
}
\description{
takes output generated by read.maf and draws an oncoplot
}
\details{
Takes an \code{\link{MAF}} object as an input and plots it as a matrix. Any desired clincal features can be added at the bottom of the oncoplot by providing \code{clinicalFeatures}.
Oncoplot can be sorted either by mutations or by clinicalFeatures using arguments \code{sortByMutation} and \code{sortByAnnotation} respectively.

By setting `pathways` argument either `sigpw` or `smgbp` - cohort can be summarized by altered pathways. pathways argument also accepts a custom pathway list in the form of a two column tsv file or a data.frame containing gene names and their corresponding pathway.
}
\examples{
laml.maf <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
laml.clin = system.file('extdata', 'tcga_laml_annot.tsv', package = 'maftools')
laml <- read.maf(maf = laml.maf, clinicalData = laml.clin)
#Basic onocplot
oncoplot(maf = laml, top = 3)
#Changing colors for variant classifications (You can use any colors, here in this example we will use a color palette from RColorBrewer)
col = RColorBrewer::brewer.pal(n = 8, name = 'Paired')
names(col) = c('Frame_Shift_Del','Missense_Mutation', 'Nonsense_Mutation', 'Multi_Hit', 'Frame_Shift_Ins',
               'In_Frame_Ins', 'Splice_Site', 'In_Frame_Del')
#Color coding for FAB classification; try getAnnotations(x = laml) to see available annotations.
fabcolors = RColorBrewer::brewer.pal(n = 8,name = 'Spectral')
names(fabcolors) = c("M0", "M1", "M2", "M3", "M4", "M5", "M6", "M7")
fabcolors = list(FAB_classification = fabcolors)
oncoplot(maf = laml, colors = col, clinicalFeatures = 'FAB_classification', sortByAnnotation = TRUE, annotationColor = fabcolors)
}
\references{
Bailey, Matthew H et al. “Comprehensive Characterization of Cancer Driver Genes and Mutations.” Cell vol. 173,2 (2018): 371-385.e18. doi:10.1016/j.cell.2018.02.060
Sanchez-Vega, Francisco et al. “Oncogenic Signaling Pathways in The Cancer Genome Atlas.” Cell vol. 173,2 (2018): 321-337.e10. doi:10.1016/j.cell.2018.03.035
}
\seealso{
\code{\link{pathways}}
}
