% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mafSuvival.R
\name{mafSurvival}
\alias{mafSurvival}
\title{Performs survival analysis}
\usage{
mafSurvival(
  maf,
  genes = NULL,
  samples = NULL,
  clinicalData = NULL,
  time = "Time",
  Status = "Status",
  groupNames = c("Mutant", "WT"),
  showConfInt = TRUE,
  addInfo = TRUE,
  col = c("maroon", "royalblue"),
  isTCGA = FALSE,
  textSize = 12
)
}
\arguments{
\item{maf}{an \code{\link{MAF}} object generated by \code{\link{read.maf}}}

\item{genes}{gene names for which survival analysis needs to be performed. Samples with mutations in any one of the genes provided are used as mutants.}

\item{samples}{samples to group by. Genes and samples are mutually exclusive.}

\item{clinicalData}{dataframe containing events and time to events. Default looks for clinical data in annotation slot of \code{\link{MAF}}.}

\item{time}{column name contining time in \code{clinicalData}}

\item{Status}{column name containing status of patients in \code{clinicalData}. must be logical or numeric. e.g, TRUE or FALSE, 1 or 0.}

\item{groupNames}{names for groups. Should be of length two. Default c("Mutant", "WT")}

\item{showConfInt}{TRUE. Whether to show confidence interval in KM plot.}

\item{addInfo}{TRUE. Whether to show survival info in the plot.}

\item{col}{colors for plotting.}

\item{isTCGA}{FALSE. Is data is from TCGA.}

\item{textSize}{Text size for surv table. Default 7.}
}
\value{
Survival plot
}
\description{
Performs survival analysis by grouping samples from maf based on mutation status of given gene(s) or manual grouping of samples.
}
\details{
This function takes MAF file and groups them based on mutation status associated with given gene(s) and performs survival analysis. Requires dataframe containing survival status and time to event.
Make sure sample names match to Tumor Sample Barcodes from MAF file.
}
\examples{
laml.maf <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
laml.clin <- system.file("extdata", "tcga_laml_annot.tsv", package = "maftools")
laml <- read.maf(maf = laml.maf,  clinicalData = laml.clin)
mafSurvival(maf = laml, genes = 'DNMT3A', time = 'days_to_last_followup', Status = 'Overall_Survival_Status', isTCGA = TRUE)

}
