% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/m6Aboost.R
\name{m6Aboost}
\alias{m6Aboost}
\title{m6Aboost for identify the m6A peaks from the miCILP2 data}
\usage{
m6Aboost(object, genome = "", normalization = TRUE)
}
\arguments{
\item{object}{A GRanges object which should contains all the single
nucleotide peaks of miCLIP2 experiment.}

\item{genome}{The name of the BSgenome that you are working with. For
example "BSgenome.Mmusculus.UCSC.mm10".}

\item{normalization}{A logical vector which indicates whether you would like
normalize the RSS and C to T reads number to the mean value of the
training set of the model. This will help to reduce the false positive
rate.}
}
\value{
A GRanges object with all the information that is required by the
    m6Aboost model.
}
\description{
An function for calculating the relative signal strength and
    extracting all the features that required by the m6Aboost model for
    each peak.
}
\examples{
    testpath <- system.file("extdata", package = "m6Aboost")
    test_gff3 <- file.path(testpath, "test_annotation.gff3")
    test <- readRDS(file.path(testpath, "test.rds"))
    test<- preparingData(test, test_gff3, colname_reads="WTmean",
        colname_C2T="CtoTmean")

    ## The input of m6Aboost should be the output from preparingData function
    ## Please make sure that the correct BSgenome package have installed
    ## before running motifProfile. For example,
    ## library("BSgenome.Mmusculus.UCSC.mm10")

    test <- m6Aboost(test, "BSgenome.Mmusculus.UCSC.mm10")
}
\author{
You Zhou
}
