% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_de.R
\name{test_global}
\alias{test_global}
\title{Differential embedding for each condition}
\usage{
test_global(
  fit,
  contrast,
  reduced_design = NULL,
  consider = c("embedding+linear", "embedding", "linear"),
  variance_est = c("analytical", "resampling", "none"),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{fit}{the result of calling \code{\link[=lemur]{lemur()}}}

\item{contrast}{Specification of the contrast: a call to \code{cond()} specifying a full observation
(e.g. \code{cond(treatment = "A", sex = "male") - cond(treatment = "C", sex = "male")} to
compare treatment A vs C for male observations). Unspecified factors default to the reference level.}

\item{reduced_design}{an alternative specification of the null hypothesis.}

\item{consider}{specify which part of the model are considered for the differential expression test.}

\item{variance_est}{How or if the variance should be estimated. \code{'analytical'} is only compatible with \code{consider = "linear"}. \code{'resampling'} is the most flexible (to adapt the number
of resampling iterations, set \code{n_resampling_iter}. Default: \code{100})}

\item{verbose}{should the method print information during the fitting. Default: \code{TRUE}.}

\item{...}{additional arguments.}
}
\value{
a data.frame
}
\description{
Differential embedding for each condition
}
