% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lefserPlot.R
\name{lefserPlot}
\alias{lefserPlot}
\title{Plots results from \code{lefser} function}
\usage{
lefserPlot(
  df,
  colors = c("c", "l", "g"),
  trim.names = TRUE,
  title = "",
  label.font.size = 3,
  label.font.color = "black",
  label.font.face = c("plain", "italic", "bold", "bold.italic"),
  ...
)
}
\arguments{
\item{df}{Data frame produced by \code{lefser}. This data frame contains two
columns labeled as \code{c("features", "scores")}.}

\item{colors}{Colors corresponding to class 0 and 1. Options: "c"
(colorblind), "l" (lefse), "g" (greyscale). Defaults to "c". This argument
also accepts a character(2) with two color names.}

\item{trim.names}{Under the default (\code{TRUE}), this function extracts the most
specific taxonomic rank of organism.}

\item{title}{A character(1). The title of the plot.}

\item{label.font.size}{A numeric(1). The font size of the feature labels. The
default is \code{3}.}

\item{label.font.color}{A character(1). The font color of the feature labels.
The default is \code{"black"}.}

\item{label.font.face}{A character(1). The font face of the feature labels.
Options are "plain", "italic", "bold", or "bold.italic". The default is
\code{"plain"}.}

\item{...}{Additional arguments passed to \code{geom_text()}}
}
\value{
Function returns plot of effect size scores produced by \code{lefser}.
Positive scores represent the biomarker is more abundant in class '1'.
Negative scores represent the biomarker is more abundant in class '0'.
}
\description{
This function plots the biomarkers found by LEfSe, that are ranked according
to their effect sizes and linked to their abundance in each class.
}
\examples{
example("lefser")
lefserPlot(res_class)

# Plot with italicized feature labels
lefserPlot(res_class, label.font.face = "italic", label.font.color = "red")

}
