% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KYCG_plotLollipop.R
\name{KYCG_plotLollipop}
\alias{KYCG_plotLollipop}
\title{creates a lollipop plot of log(estimate) given data with
fields estimate.}
\usage{
KYCG_plotLollipop(df, label_column = "dbname", n = 20)
}
\arguments{
\item{df}{DataFrame where each row is a database name with its
estimate.}

\item{label_column}{column in df to be used as the label (default: dbname)}

\item{n}{Integer representing the number of top enrichments to report.
Optional. (Default: 10)}
}
\value{
ggplot lollipop plot
}
\description{
creates a lollipop plot of log(estimate) given data with
fields estimate.
}
\examples{

KYCG_plotLollipop(data.frame(
  estimate=runif(10,0,10), FDR=runif(10,0,1), nD=runif(10,10,20),
  overlap=as.integer(runif(10,0,30)), group="g",
  dbname=as.character(seq_len(10))))

}
