% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadDBs.R
\name{loadDBs}
\alias{loadDBs}
\title{Load knowledgebase databases from TSV files}
\usage{
loadDBs(in_paths)
}
\arguments{
\item{in_paths}{Character vector of file paths, URLs to .tsv or
.tsv.gz files, or a single directory path containing such files.
If a directory is provided, all files in that directory will be loaded.
URLs (starting with http:// or https://) are loaded directly.}
}
\value{
A list of database vectors. Each element contains Probe_IDs with
attributes:
\itemize{
  \item \code{group} - The database group name
    (derived from filename)
  \item \code{dbname} - The knowledgebase name
    (from the Knowledgebase column)
}
}
\description{
This used to be an exported function. Now it's internal. Use RDS download
directly.
}
\details{
This function loads knowledgebase sets from tab-delimited (.tsv or .tsv.gz)
files downloaded from Zenodo or other sources. The TSV files should contain
two columns: "Probe_ID" and "Knowledgebase". The function splits the data
by knowledgebase name and returns a list of database vectors.


The input TSV file(s) must have a header row and contain at least
two columns:
\itemize{
  \item \code{Probe_ID} - Probe identifiers (e.g., cg12345678)
  \item \code{Knowledgebase} - Knowledgebase/database name
}
}
