% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ucoxpred.R
\name{ucox_pred}
\alias{ucox_pred}
\title{Fit and validate Cox regression models}
\usage{
ucox_pred(
  obj1,
  obj2,
  bfname,
  wdir = getwd(),
  min_uval = 50,
  psort = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{obj1}{SummarizedExperiment object with training expression}

\item{obj2}{SummarizedExperiment object with test expression}

\item{bfname}{a character string (character vector of length 1) that 
specifies the base name used to create the output file names, which 
are created by adding '_cox_train_sum.txt', '_train_scores.txt', and 
'_test_scores.txt' to 'bfname'.}

\item{wdir}{a character string (character vector of length 1) that
specifies the name of the working directory for the output files 
(defaults to the current R directory).}

\item{min_uval}{numeric value that specifies the minimal percentage of
unique values per feature (default is 50).
Features that have less than 'min_uval' percent unique values are
excluded from the analysis.}

\item{psort}{logical value whether to sort the output table by p-values
in increasing order (default is FALSE).}

\item{verbose}{logical value whether to print progress (default is TRUE).}
}
\value{
no return value
}
\description{
For each feature, fits a univariate Cox regression model on training data
and then uses the model to predict the risk score for test data.
}
\examples{

# Example with data files included in the package:

# Load training (fdat1) and test (fdat2) gene expression data
# files and survival data file (sdat).
fdat1 <- system.file("extdata", "expression_data_1.txt", package = "kmcut")
fdat2 <- system.file("extdata", "expression_data_2.txt", package = "kmcut")
sdat <- system.file("extdata", "survival_data.txt", package = "kmcut")

# Create SummarizedExperiment object with training data
se1 <- create_se_object(efile = fdat1, sfile = sdat)

# Create SummarizedExperiment object with test data
se2 <- create_se_object(efile = fdat2, sfile = sdat)

# Fit Cox model on the training data and use it to calculate the risk
# scores for the test data.
ucox_pred(obj1 = se1, obj2 = se2, bfname = "demo", min_uval = 90)

# This will create three output files in the current working directory:
# 1) Tab-delimited text file with Cox summary for the training data:
# "demo_cox_train_sum.txt"
# 2) Tab-delimited text file with the risk scores for training data:
# "demo_train_scores.txt"
# 3) Tab-delimited text file with the risk scores for test data:
# "demo_test_scores.txt"
}
