% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kpPolygon.R
\name{kpPolygon}
\alias{kpPolygon}
\title{kpPolygon}
\usage{
kpPolygon(karyoplot, data=NULL, chr=NULL, x=NULL, y=NULL, ymin=NULL, ymax=NULL, data.panel=1, r0=NULL, r1=NULL, clipping=TRUE, ...)
}
\arguments{
\item{karyoplot}{(a \code{KaryoPlot} object) This is the first argument to all data plotting functions of \code{karyoploteR}. A KaryoPlot object referring to the currently active plot.}

\item{data}{(a \code{GRanges}) A GRanges object with the data. If \code{data} is present, \code{chr} will be set to \code{seqnames(data)} and \code{x} to the midpoints of the rages in data. If no parameter \code{y} is specified and \code{data} has a column named \code{y} or \code{value} this column will be used to define the \code{y} value of each data point. (defaults to NULL)}

\item{chr}{(a charecter vector) A vector of chromosome names specifying the chromosomes of the data points. If \code{data} is not NULL, \code{chr} is ignored. (defaults to NULL)}

\item{x}{(a numeric vector) A numeric vector with the positions (in base pairs) of the data points in the chromosomes. If \code{data} is not NULL, \code{x} is ignored. (defaults to NULL)}

\item{y}{(a numeric vector) A numeric vector with the values of the data points. If \code{y} is not NULL, it is used instead of any data column in \code{data}. (defaults to NULL)}

\item{ymin}{(numeric) The minimum value of \code{y} to be plotted. If NULL, it is set to the min value of the selected data panel. (defaults to NULL)}

\item{ymax}{(numeric) The maximum value of \code{y} to be plotted. If NULL, it is set to the max value of the selected data panel. (defaults to NULL)}

\item{data.panel}{(numeric) The identifier of the data panel where the data is to be plotted. The available data panels depend on the plot type selected in the call to \code{\link{plotKaryotype}}. (defaults to 1)}

\item{r0}{(numeric) r0 and r1 define the vertical range of the data panel to be used to draw this plot. They can be used to split the data panel in different vertical ranges (similar to tracks in a genome browser) to plot differents data. If NULL, they are set to the min and max of the data panel, it is, to use all the available space. (defaults to NULL)}

\item{r1}{(numeric) r0 and r1 define the vertical range of the data panel to be used to draw this plot. They can be used to split the data panel in different vertical ranges (similar to tracks in a genome browser) to plot differents data. If NULL, they are set to the min and max of the data panel, it is, to use all the available space. (defaults to NULL)}

\item{clipping}{(boolean) Only used if zooming is active. If TRUE, the data representation will be not drawn out of the drawing area (i.e. in margins, etc) even if the data overflows the drawing area. If FALSE, the data representation may overflow into the margins of the plot. (defaults to TRUE)}

\item{...}{The ellipsis operator can be used to specify any additional graphical parameters. Any additional parameter will be passed to the internal calls to the R base plotting functions.}
}
\value{
Returns the original karyoplot object, unchanged.
}
\description{
Plots the the given polygons along the genome
}
\details{
This is one of the functions from karyoploteR implementing the adaptation to the genome context 
of basic plot functions from R base graphics. 
Given a set of positions on the genome (chromosome, base and y), it plots the polygons 
defined by taking these position as vertices. 
Data can be provided via a \code{GRanges} object (\code{data}), independent
parameters for chr, x and y or a combination of both. A number of parameters can be used 
to define exactly where and how the polygon is drawn. In addition, via the ellipsis operator 
(\code{...}), \code{kpPolygon} accepts any parameter valid for \code{polygon} 
(e.g. \code{border}, \code{density}, \code{fillOddEven}, ...)
}
\note{
IMPORTANT: \code{kpPolygon} allows the creation of polygons 
encompassing multilple chromosomes. In some cases, when plotting only some
of the chromosomes or when zooming, the default data filtering automatically 
discards some points before plotting, altering the polygon shape. See example
below.
}
\examples{
 
set.seed(1000)
x <- c(1,2,5,9,13,20,15,11,7,3)*10000000
y <- c(0,1,0.8,0.2,0.5,0.2,1,0.3,0.1,0.2)

kp <- plotKaryotype("hg19", plot.type=2, chromosomes=c("chr1", "chr2"))
  kpDataBackground(kp, data.panel=1)
  kpDataBackground(kp, data.panel=2)

  kpPolygon(kp, chr="chr1", x=x, y=y, col="red")
  kpPolygon(kp, chr="chr1", x=x, y=y, col="orange", r0=0.2, r1=0.8, density=30)
  #use kpPolygon to draw triangles at the specified positions
  chr2.x <- c(1,3,7,26,48,79,120, 124, 128)*1000000
  for(x in chr2.x) {
    kpPolygon(kp, chr="chr2", x=c(x-2000000, x+2000000, x), y=c(1,1,0), r0=0, r1=0.3, col="lightblue")
  }
  
  
#Effect of data filtering
  
dp <- toGRanges(data.frame(rep(paste0("chr", (1:2)), 3), 10e6*1:6, 10e6*1:6+5e5, y=c(0,0,1,1,0,0)))
kp <- plotKaryotype(chromosomes=c("chr1", "chr2"))
kpPolygon(kp, dp)

kp <- plotKaryotype(chromosomes=c("chr2"))
kpPolygon(kp, dp)

 
}
\seealso{
\code{\link{plotKaryotype}}, \code{\link{kpLines}}, \code{\link{kpPoints}}

\code{\link{kpPlotRegions}}
}
